/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.network.packet;

import dev.toma.gunsrpg.api.common.data.IKillData;
import dev.toma.gunsrpg.api.common.data.IPerkProvider;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.api.common.data.ISkillProvider;
import dev.toma.gunsrpg.api.common.skill.ISkillHierarchy;
import dev.toma.gunsrpg.api.common.skill.ISkillProperties;
import dev.toma.gunsrpg.api.common.skill.ITransactionValidator;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.network.AbstractNetworkPacket;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class C2S_RequestExtensionSkillLockPacket
extends AbstractNetworkPacket<C2S_RequestExtensionSkillLockPacket> {
    private final SkillType<?> head;

    public C2S_RequestExtensionSkillLockPacket() {
        this(null);
    }

    public C2S_RequestExtensionSkillLockPacket(SkillType<?> head) {
        this.head = head;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeRegistryId(this.head);
    }

    @Override
    public C2S_RequestExtensionSkillLockPacket decode(PacketBuffer buffer) {
        return new C2S_RequestExtensionSkillLockPacket((SkillType)buffer.readRegistryId());
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        PlayerData.get((PlayerEntity)player).ifPresent(data -> {
            ISkillProvider skillProvider = data.getSkillProvider();
            IPerkProvider provider = data.getPerkProvider();
            if (provider.getPoints() < 25) {
                return;
            }
            ISkillHierarchy<?> hierarchy = this.head.getHierarchy();
            SkillType<?>[] children = hierarchy.getExtensions();
            if (children == null || children.length == 0) {
                return;
            }
            boolean lockedAny = false;
            for (SkillType<?> type : children) {
                ISkillProperties childProps = type.getProperties();
                if (!skillProvider.hasSkill(type)) continue;
                lockedAny = true;
                skillProvider.lock(type);
                ITransactionValidator validator = childProps.getTransactionValidator();
                IKillData pointProvider = validator.getData((IPlayerData)data);
                pointProvider.awardPoints(childProps.getPrice());
            }
            if (lockedAny) {
                provider.awardPoints(-25);
            }
            data.sync(-1);
        });
    }
}

